import { View, Text, Pressable } from "react-native";
import React from "react";
import { allCategoriesStyle } from "./categoriesStyle";
import { useNavigation } from "@react-navigation/native";
import { BASE_API_URL_STG } from "@env";

const SubCategory = ({ item, index, dataLength }) => {
    const navigation = useNavigation();
    const handleViewSubCategory = () => {
        const subCategoryProductUrl = `${BASE_API_URL_STG}/user/products?categories=${item?.slug}`;
        navigation.navigate("feature display", {
            name: item.name,
            url: subCategoryProductUrl,
        });
    };
    return (
        <>
            <Pressable
                onPress={handleViewSubCategory}
                android_ripple={{ color: "gray" }}
            >
                <Text style={allCategoriesStyle.singleSubText}>
                    {item.name}
                </Text>
            </Pressable>
            <View style={allCategoriesStyle.singleSubLine} />
            
        </>
    );
};

export default SubCategory;
